﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using PsgBase;
using PsgIntl;

namespace Territories
{
    [EditorClass, ViewGrid]
    public partial class Territories : Base
    {
        #region Members
        TerritoriesBE.TerritoriesDataTable table = new TerritoriesBE.TerritoriesDataTable();
        TerritoriesBE.TerritoriesRow rowA = null;
        #endregion

        #region Constructors

        public Territories()
        {
            InitializeComponent();
        }

        public Territories(ViewGrid _browser)
            : base(_browser)
        {
            InitializeComponent();
        }

        public Territories(LookupGrid _search)
            : base(_search)
        {
            InitializeComponent();
        }

        #endregion Constructors

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "territoryid";
            context.PsgFieldDisplay = "territorydescription";
            context.PsgCommand = "territories";
            context.PsgServerTableName = "territories";
        }

        public override void PsgStart()
        {
            base.PsgStart();

            AddTable("territories", ID, "C");
            AddTable("region", "null", "C");
            GetTables(this);
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "REGION":
                    cbRegion.PsgComboTable = this.Intf.PsgTableServer;
                    cbRegion.DataSource = cbRegion.PsgComboTable;
                    cbRegion.DisplayMember = "regiondescription";
                    cbRegion.ValueMember = "regionid";
                    break;

                case "TERRITORIES":
                    table = (TerritoriesBE.TerritoriesDataTable)SetMainData(dt, table);
                    rowA = (TerritoriesBE.TerritoriesRow)table.Rows[0];
                    break;
            }
        }

        public override void PsgBind()
        {
            BindEdit(edTerritory, table.territorydescriptionColumn);
            BindCombo(cbRegion, table.regionColumn, table.regionidColumn);

            base.PsgBind();
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.territorydescriptionColumn, GetIntl(Intl.Territory), 150);
            this.ColumnsView(table.regionColumn, GetIntl(Intl.Region));

            this.FiltersView(table.territorydescriptionColumn, GetIntl(Intl.Territory));
            this.FiltersView(table.regionColumn, GetIntl(Intl.Region));
        }
    }
}
